"""
    Copyright 2017 Cognitive Computation Lab
    University of Freiburg
    Nicolas Riesterer <riestern@tf.uni-freiburg.de>

    Command line interface for the exemplary model for the syllogistic
    reasoning challenge 2017.
"""

import numpy as np

import featureselection

# Default: 10000 simulations
n_simulations = 10000

# Construct the syllogism identifiers AA1 to OO4
MOODS = ["A", "I", "E", "O"]
syllogs = []
for a in MOODS:
    for b in MOODS:
        for f in range(1, 5):
            syllogs.append(a + b + str(f))

# Prepare the CSV output header
OPTIONS = ["Aac", "Iac", "Eac", "Oac", "Aca", "Eca", "Ica", "Oca", "NVC"]
print("Syllog", ", ".join(OPTIONS))

# Iterate over syllogisms and compute the predictions
for task in syllogs:
    # Predict responses for the simulated reasoners
    fs = featureselection.FeatureSelection()
    result = {}
    for sim in range(n_simulations):
        prediction = fs.predict(task)
        if prediction in result:
            result[prediction] += 1
        else:
            result[prediction] = 1

    # Print the predictions to stdout
    frequencies = []
    for option in OPTIONS:
        if option in result:
            frequencies.append(result[option])
        else:
            frequencies.append(0)

    frequencies = np.array(frequencies)
    frequencies = frequencies / frequencies.sum()

    print(task + " " + ", ".join(str(x) for x in frequencies))
